/**
 * jQuery ObjectVR plugin
 * this requried pre-rendered images, sequenced by horizontal and vertical count.
 * It's also provided a script to export imaged with Cheetah3D ( 3D CG Application ).
 * @name jquery-objectvr-0.1.js
 * @author Hiroto Tsubaki tres-graficos.jp
 * @version 0.1
 * @date Dec 18, 2010
 * @category jQuery plugin
 * @copyright (c) 2010 Hiroto Tsubaki
 * @license CCAttribution-ShareAlike 2.5 Brazil - http://creativecommons.org/licenses/by-sa/2.5/br/deed.en_US
 * @example Visit http://tres-graficos.jp/blog/ for more informations about this jQuery plugin
 */

(function($) {
	
	$.fn.objectVR = function( settings ) {
	
		settings = jQuery.extend( {
			
			viewWidth: 640,
			viewHeight: 480,
			
			sectionH: 0,
			sectionV: 0,
			
			initialH: 0,
			initialV: 0,
			
			imgName: 'img',
			imgExt: '.jpg',
			
			scaleMax: 100,
			scaleMin: 100,
			scaleIni: 100,
			
			trackballThreshold: 250,
			
			assetsUrl: 'assets',
			reverseControl: 0,
			
			btnUp:    '#bn-up', 
			btnDown:  '#bn-down', 
			btnLeft:  '#bn-left',
			btnRight: '#bn-right',
			
			btnZoomUp: '#bn-zoomup',
			btnZoomDown: '#bn-zoomdown',
			
			btnReset: '#bn-reset',
			
			navigationBoxAppend: true,
			navigationBox: '#navigation',
			navigationBoxAutoHide: true,
			
			loadingBoxAppend: true,
			loadingBox: '#loading',
			
			btnOffStateClassName: 'btn-off'
			
		}, settings );
		
		var vrView = $(this);
		
		if (settings.navigationBoxAppend) {
			vrView.append('<div id="navigation"><div class="nav-button" id="bn-up"></div><div class="nav-button" id="bn-left"></div><div class="nav-button" id="bn-reset"></div><div class="nav-button" id="bn-right"></div><div class="nav-button" id="bn-down"></div><div class="nav-button" id="bn-zoomup"></div><div class="nav-button" id="bn-zoomdown"></div></div>');
		}
		if (settings.loadingBoxAppend) {
			vrView.append('<div id="loading">starting.</div>');
		}
		
		var navigationBox = $(settings.navigationBox);
		var btnUp = $(settings.btnUp);
		var btnDown = $(settings.btnDown);
		var btnLeft = $(settings.btnLeft);
		var btnRight = $(settings.btnRight);
		
		var btnZoomUp = $(settings.btnZoomUp);
		var btnZoomDown = $(settings.btnZoomDown);
		
		var btnReset = $(settings.btnReset);
		var loadingBox = $(settings.loadingBox);
		
		var validateBn = (function() {
			var offstate = settings.btnOffStateClassName;
			var reverse = settings.reverseControl;
			return function() {
				if ( currentScale == scaleMax ) {
					btnZoomUp.addClass(offstate);
				} else {
					btnZoomUp.removeClass(offstate);
				}
				if ( currentScale == scaleMin ) {
					btnZoomDown.addClass(offstate);
				} else {
					btnZoomDown.removeClass(offstate);
				}
				if ( currentV == sectionV * reverse ) {
					btnUp.addClass(offstate);
				} else {
					btnUp.removeClass(offstate);
				}
				if ( currentV == sectionV * reverse * -1 ) {
					btnDown.addClass(offstate);
				} else {
					btnDown.removeClass(offstate);
				}
				if ( currentH == sectionH * reverse ) {
					btnLeft.addClass(offstate);
				} else {
					btnLeft.removeClass(offstate);
				}
				if ( currentH == sectionH * reverse * -1 ) {
					btnRight.addClass(offstate);
				} else {
					btnRight.removeClass(offstate);
				}
				if ( currentH == initialH && currentV == initialV && currentScale == scaleIni ) {
					btnReset.addClass(offstate);
				} else {
					btnReset.removeClass(offstate);
				}
			}
		})();
		
		var resetView = (function() {
			return function() {
				currentH = settings.initialH;
				currentV = settings.initialV;
				currentScale = settings.scaleIni;
				vrView.css( 'background-image', 'url('+assetsUrl+'/'+imgName+'_'+currentH+'_'+currentV+imgExt+')' );
				updateViewScale();
				validateBn();
			}
		})();
		
		var preloadImages = function() {
			var ci = imgs.length;
			imgs[ ci ] = new Image;
			imgs[ ci ].onload = checkimageloaded; 
			imgs[ ci ].onerror = checkerror;
			imgs[ ci ].src = imgs_holder[ ci ].src;
		}
		
		var checkImageLoaded = function() {
			var loaded = 0;
			
			return (function() {
				loaded++;
				loadingBox.html( (loaded / imgs_holder.length * 100).toFixed(1) + '%' );
				if (loaded == imgs_holder.length) {
					setupView();
					validateBn();
					loadingBox.html(' complete. ');
					loadingBox.fadeOut( 1000, function() { vrView.fadeIn(); } );
					navigationBox.fadeIn();
				} else {
					preloadImages();
				}
			})
		}
		
		var checkError = function() {
			return (function() {
				// image loading error.
				loadingBox.html(' image not found. <br />' + this['src'] + '<br />object vr won\'t start. ' );
			})
		}
		
		var updateImage = (function ( h, v ) {
			var assetsUrl = settings.assetsUrl;
			var sec_h = settings.sectionH;
			var sec_v = settings.sectionV;
			
			return function( h, v ) {
				if (h > 0) {
					currentH = ( currentH + 1 > sec_h )? sec_h : currentH + 1;
				} else if ( h < 0 ) {
					currentH = ( currentH - 1 < -1 * sec_h )? -1*sec_h : currentH - 1;
				}
				if (v > 0) {
					currentV = ( currentV + 1 > sec_v )? sec_v : currentV + 1;
				} else if ( v < 0 ) {
					currentV = ( currentV - 1 < -1 * sec_v)? -1 * sec_v : currentV - 1;
				}
				vrView.css( 'background-image', 'url('+assetsUrl+'/'+imgName+'_'+currentH+'_'+currentV+imgExt+')' );
				validateBn();
			}
		})();
		
		var zoomUpView = function( ) {
			currentScale = (currentScale + 10 > scaleMax)? scaleMax : currentScale + 10;
			updateViewScale();
			validateBn();
		}
		
		var zoomDownView = function( ) {
			currentScale = (currentScale - 10 < scaleMin)? scaleMin : currentScale - 10;
			updateViewScale();
			validateBn();
		}
		
		var updateViewScale = (function() {
			var prop = {};
			return function (scale) {
				prop[bgSizePropertyName] = currentScale + '%';
				vrView.animate( prop, 200 );
			}
		})();
		
		var updateConsole = function() {
			$('#console').html( '('+imgName+'_' + currentH + '_' +  currentV + imgExt + ', ' + currentScale.toFixed(2) + '%' + ')'  );
		};
		
		var trackball = function( event ) {
			var cx, cy, dx, dy, hi, vi;
			var threshold = settings.trackballThreshold / (( sectionH > sectionV )? sectionH : sectionV );
			var dxs = 0;
			var dys = 0;
			var reverse = settings.reverseControl;
			
			return ( function( event ) {
				if (stateTrackball) {
					hi = 0;
					vi = 0;
					cx = (event.pageX - vrView.offset().left);
					cy = (event.pageY - vrView.offset().top);
					dx = Math.floor((sx - cx)/1);
					dy = Math.floor((sy - cy)/1);
					sx = cx;
					sy = cy;
					
					dxs += dx;
					dys += dy;
					
					if (Math.abs( dxs ) > threshold) {
						hi = dxs;
						dxs = 0;
					}
					
					if (Math.abs( dys ) > threshold) {
						vi = dys;
						dys = 0;
					}
					updateImage( hi * reverse, vi * reverse );
				}
			})
		};
		
		var imgs_holder = [];
		var imgs = [];
		
		var checkimageloaded = checkImageLoaded();;
		var checkerror = checkError();
		
		var sx = 0;
		var sy = 0;
		
		var stateTrackball = false;
		
		var currentH, currentV, currentScale;
		
		var bgSizePropertyName = '';
		if ($.browser.mozilla) {
			bgSizePropertyName = "-moz-background-size";
		} else {
			bgSizePropertyName = "background-size";
		}
		
		// prelaod
		var i, j;
		var pre = 0;
		var sectionH = settings.sectionH;
		var sectionV = settings.sectionV;
		var initialH = settings.initialH;
		var initialV = settings.initialV;
		var scaleMax = settings.scaleMax;
		var scaleMin = settings.scaleMin;
		var scaleIni = settings.scaleIni;
		var reverseControl = settings.reverseControl;
		var imgName = settings.imgName;
		var imgExt = settings.imgExt;
		var assetsUrl = settings.assetsUrl;
		
		// init
		currentH = initialH;
		currentV = initialV;
		currentScale = scaleIni;
		
		imgs_holder[pre] = {};
		imgs_holder[pre].src = assetsUrl+'/'+imgName+'_0_0'+imgExt;
		pre++;
		for ( i = 0;i < sectionH;i++) {
			imgs_holder[pre] = {};
			imgs_holder[pre].src = assetsUrl+'/'+imgName+'_'+(i+1)+'_0'+imgExt;
			pre++;
			imgs_holder[pre] = {};
			imgs_holder[pre].src = assetsUrl+'/'+imgName+'_-'+(i+1)+'_0'+imgExt;
			pre++;
		}
		for ( j = 0;j < sectionV;j++) {
			imgs_holder[pre] = {};
			imgs_holder[pre].src = assetsUrl+'/'+imgName+'_0_'+(j+1)+imgExt;
			pre++;
			imgs_holder[pre] = {};
			imgs_holder[pre].src = assetsUrl+'/'+imgName+'_0_-'+(j+1)+imgExt;
			pre++;
		}
		for ( i = 0;i < sectionH;i++ ) {
			for( j = 0;j < sectionV;j++ ) {
				imgs_holder[pre] = {};
				imgs_holder[pre].src = assetsUrl+'/'+imgName+'_'+(i+1)+'_'+(j+1)+imgExt;
				pre++;
				imgs_holder[pre] = {};
				imgs_holder[pre].src = assetsUrl+'/'+imgName+'_-'+(i+1)+'_'+(j+1)+imgExt;
				pre++;
				imgs_holder[pre] = {};
				imgs_holder[pre].src = assetsUrl+'/'+imgName+'_'+(i+1)+'_-'+(j+1)+imgExt;
				pre++;
				imgs_holder[pre] = {};
				imgs_holder[pre].src = assetsUrl+'/'+imgName+'_-'+(i+1)+'_-'+(j+1)+imgExt;
				pre++;
			}
		}
		
		var setupView = function() {
			// navigation setting
			  btnZoomUp.click( zoomUpView );
			btnZoomDown.click( zoomDownView );
			
			   btnUp.click( function( event ) { updateImage( 0, 1 * reverseControl ); });
			 btnDown.click( function( event ) { updateImage( 0,-1 * reverseControl ); });
			 btnLeft.click( function( event ) { updateImage( 1 * reverseControl, 0 ); });
			btnRight.click( function( event ) { updateImage(-1 * reverseControl, 0 ); });
			btnReset.click( function( event ) { resetView( event ); });
			// view setting
			  vrView.mousedown(function( ) { stateTrackball = true; })
					.mouseup( function( ) { stateTrackball = false; })
					.mousemove( trackball() )
					.mouseenter( function( ) { if (settings.navigationBoxAutoHide) navigationBox.fadeIn(); })
					.mouseleave( function( ) { if (settings.navigationBoxAutoHide) navigationBox.fadeOut(); })
		}
		
		  vrView.css('width', settings.viewWidth+'px')
				.css('height', settings.viewHeight+'px')
				.css( 'background-image', 'url('+assetsUrl+'/'+imgName+'_'+currentH+'_'+currentV+imgExt+')' )
				.css( bgSizePropertyName, currentScale + '%' );
		
		if (settings.navigationBoxAutoHide) navigationBox.fadeOut('fast');
		
		// start image load
		  vrView.click( function() {
			$(this).unbind( 'click' );
			preloadImages();
		})
		loadingBox.html("click to start.");
		
		return this;
	}
})(jQuery);
